/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.login.api;

import com.nickuc.login.api.enums.AccountType;
import com.nickuc.login.api.enums.DatabaseType;
import com.nickuc.login.api.enums.ImplementationType;
import com.nickuc.login.api.enums.SpawnType;
import com.nickuc.login.api.event.internal.LockableEvent;
import com.nickuc.login.api.event.internal.LockableNewActionEvent;
import com.nickuc.login.api.nLoginAPIHolder;
import com.nickuc.login.api.types.AccountData;
import com.nickuc.login.api.types.Identity;
import com.nickuc.login.api.types.Location;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface nLoginAPI {
    @Nonnull
    public static nLoginAPI getApi() {
        return nLoginAPIHolder.getApi();
    }

    public boolean isAvailable();

    @Nonnull
    public String getVersion();

    public int getApiVersion();

    @Nonnull
    public ImplementationType getImplementationType();

    public DatabaseType getDatabaseType();

    public Optional<Location> getSpawnLocation(@Nonnull SpawnType var1);

    public Optional<AccountData> getAccount(@Nonnull Identity var1);

    @Nonnull
    public Iterator<AccountData> getAccounts();

    @Nonnull
    public List<AccountData> getAccountsByIp(@Nonnull String var1);

    public boolean isAuthenticated(@Nonnull Identity var1);

    public boolean isAuthenticated(@Nonnull String var1);

    public int getRemainingSeconds(@Nonnull Identity var1);

    default public int getRemainingSeconds(@Nonnull String playerName) {
        return this.getRemainingSeconds(Identity.ofKnownName(playerName));
    }

    @Nullable
    default public String getRealName(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(AccountData::getLastName).orElse(null);
    }

    @Nullable
    default public String getHashedPassword(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).flatMap(AccountData::getHashedPassword).orElse(null);
    }

    @Nullable
    default public String getAddress(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(AccountData::getLastIP).orElse(null);
    }

    @Nonnull
    default public Instant getLastLogin(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(AccountData::getLastLogin).orElse(Instant.ofEpochMilli(0L));
    }

    default public long getLastLoginUnix(@Nonnull String playerName) {
        return this.getLastLogin(playerName).toEpochMilli();
    }

    @Nonnull
    default public Instant getRegisterDate(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(AccountData::getCreationDate).orElse(Instant.ofEpochMilli(0L));
    }

    default public long getRegisterDateUnix(@Nonnull String playerName) {
        return this.getRegisterDate(playerName).toEpochMilli();
    }

    @Nullable
    default public String getEmail(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).flatMap(AccountData::getEmail).orElse(null);
    }

    @Nullable
    default public String getDiscord(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).flatMap(AccountData::getDiscordId).orElse(null);
    }

    default public boolean hasEmail(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(account -> account.getEmail().isPresent()).orElse(false);
    }

    default public boolean hasDiscord(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(account -> account.getDiscordId().isPresent()).orElse(false);
    }

    @Nonnull
    default public String getLanguage(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(account -> account.getLanguage().orElse("other")).orElse("other");
    }

    public boolean comparePassword(AccountData var1, String var2);

    default public boolean comparePassword(String playerName, String plainPassword) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(account -> account.comparePassword(plainPassword)).orElse(false);
    }

    default public boolean isRegistered(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).isPresent();
    }

    default public boolean isPremium(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(AccountData::getType).orElse(null) == AccountType.PREMIUM;
    }

    default public boolean isBedrock(@Nonnull String playerName) {
        return this.getAccount(Identity.ofKnownName(playerName)).map(AccountData::getType).orElse(null) == AccountType.BEDROCK;
    }

    public void requestLogin(@Nonnull Identity var1, @Nonnull Object var2);

    default public void requestLogin(@Nonnull String playerName, @Nonnull Object plugin) {
        this.requestLogin(Identity.ofKnownName(playerName), plugin);
    }

    default public boolean performRegister(@Nonnull Identity identity, @Nonnull String plainPassword) {
        return this.performRegister(identity, plainPassword, null);
    }

    public boolean performRegister(@Nonnull Identity var1, @Nonnull String var2, @Nullable String var3);

    default public boolean performRegister(@Nonnull String playerName, @Nonnull String plainPassword) {
        return this.performRegister(Identity.ofKnownName(playerName), plainPassword, null);
    }

    default public boolean performRegister(@Nonnull String playerName, @Nonnull String plainPassword, @Nullable String ip) {
        return this.performRegister(Identity.ofKnownName(playerName), plainPassword, ip);
    }

    public boolean performUnregister(@Nonnull Identity var1);

    default public boolean performUnregister(@Nonnull String playerName) {
        return this.performUnregister(Identity.ofKnownName(playerName));
    }

    public boolean changePassword(@Nonnull Identity var1, @Nonnull String var2);

    default public boolean changePassword(@Nonnull String playerName, @Nonnull String newPassword) {
        return this.changePassword(Identity.ofKnownName(playerName), newPassword);
    }

    public boolean setEmail(@Nonnull Identity var1, @Nullable String var2);

    default public boolean setEmail(@Nonnull String playerName, @Nullable String newEmail) {
        return this.setEmail(Identity.ofKnownName(playerName), newEmail);
    }

    public boolean setDiscord(@Nonnull Identity var1, long var2);

    default public boolean setDiscord(@Nonnull String playerName, long newAccountId) {
        return this.setDiscord(Identity.ofKnownName(playerName), newAccountId);
    }

    public boolean setLanguage(@Nonnull Identity var1, @Nullable String var2);

    default public boolean forceLogin(@Nonnull Identity identity) {
        return this.forceLogin(identity, true);
    }

    public boolean forceLogin(@Nonnull Identity var1, boolean var2);

    default public boolean forceLogin(@Nonnull String playerName) {
        return this.forceLogin(Identity.ofKnownName(playerName), true);
    }

    default public boolean forceLogin(@Nonnull String playerName, boolean showMessages) {
        return this.forceLogin(Identity.ofKnownName(playerName), showMessages);
    }

    @Nonnull
    public nLoginInternal internal();

    public static interface nLoginInternal {
        public void lockableNewAction(LockableNewActionEvent<?> var1);

        public void lockableEvent(LockableEvent var1, byte var2, byte var3);

        public Identity createIdentity(String var1, UUID var2, UUID var3, AccountType var4);

        public Identity createIdentityFromKnownName(String var1);
    }
}

