/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api.events;

import com.nickuc.chat.api.events.internal.MultiFragmentableMessageEvent;
import com.nickuc.chat.api.events.internal.SpoofableEvent;
import com.nickuc.chat.api.nChatAPI;
import com.nickuc.chat.api.util.Component;
import com.nickuc.chat.api.util.MessagePiece;
import com.nickuc.chat.api.util.map.MessagePieceMap;
import com.nickuc.chat.channel.PrivateChannel;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class PrivateMessageEvent
extends MultiFragmentableMessageEvent<PrivateMessageEvent>
implements SpoofableEvent {
    @Nonnull
    private final Player sender;
    @Nonnull
    private final Player target;
    @Nonnull
    private final PrivateChannel senderChannel;
    @Nonnull
    private final PrivateChannel targetChannel;
    private boolean spoofSend;

    public PrivateMessageEvent(@Nonnull PrivateChannel senderChannel, @Nonnull PrivateChannel targetChannel, @Nonnull Player sender, @Nonnull Player target, @Nonnull String message) {
        super(message, 3, targetChannel.getSenderFormat(), senderChannel.getTargetFormat(), senderChannel.getSpyFormat());
        this.sender = sender;
        this.target = target;
        this.senderChannel = senderChannel;
        this.targetChannel = targetChannel;
    }

    @Nonnull
    public Player getSender() {
        return this.sender;
    }

    @Nonnull
    public Player getTarget() {
        return this.target;
    }

    @Override
    public boolean isSpoofSend() {
        return this.spoofSend;
    }

    @Override
    public void setSpoofSend() {
        if (!this.spoofSend) {
            this.recipients.removeIf(player -> !player.getName().equals(this.sender.getName()));
        }
        this.spoofSend = true;
    }

    @Nonnull
    public PrivateChannel getChannel() {
        return this.senderChannel;
    }

    @Nonnull
    public PrivateChannel getSenderChannel() {
        return this.senderChannel;
    }

    @Nonnull
    public PrivateChannel getTargetChannel() {
        return this.targetChannel;
    }

    @Nonnull
    public String getSenderFormat() {
        return this.getFormat(Type.SENDER);
    }

    @Nonnull
    public String getTargetFormat() {
        return this.getFormat(Type.TARGET);
    }

    @Nonnull
    public String getSpyFormat() {
        return this.getFormat(Type.SPY);
    }

    public Optional<MessagePiece> getPiece(String tag, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            throw new IllegalArgumentException("Invalid type! " + (Object)((Object)type));
        }
        return super.getPiece(type.id, tag);
    }

    @Nonnull
    public MessagePieceMap getPieces(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            throw new IllegalArgumentException("Invalid type! " + (Object)((Object)type));
        }
        return super.getPieces(type.id);
    }

    public Optional<Component> getTagComponent(String tag, Type type) {
        return this.getPiece(tag, type).map(MessagePiece::component);
    }

    public Optional<TextComponent> getTag(String tag, Type type) {
        return this.getPiece(tag, type).map(piece -> Component.to(piece.component(), TextComponent.class));
    }

    @Nonnull
    public TextComponent getTagValue(String tag, Type type) {
        Component component = this.getTagComponent(tag, type).orElse(nChatAPI.getApi().internal().emptyReadOnlyComponent());
        return Component.to(component, TextComponent.class);
    }

    public void setTag(String tag, Component component, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null! Tag: {" + tag + "}");
        }
        Consumer<MessagePiece> consumer = piece -> piece.editComponent(component.clone());
        if (type == Type.ALL) {
            this.getPiece(tag, Type.SENDER).ifPresent(consumer);
            this.getPiece(tag, Type.TARGET).ifPresent(consumer);
            this.getPiece(tag, Type.SPY).ifPresent(consumer);
        } else {
            this.getPiece(tag, type).ifPresent(consumer);
        }
    }

    public PrivateMessageEvent setTag(String tag, TextComponent component, Type type) {
        this.setTag(tag, Component.from(component), type);
        return this;
    }

    public PrivateMessageEvent setTag(String tag, String content, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null! Tag: {" + tag + "}");
        }
        Consumer<MessagePiece> consumer = piece -> piece.editText(content);
        if (type == Type.ALL) {
            this.getPiece(tag, Type.SENDER).ifPresent(consumer);
            this.getPiece(tag, Type.TARGET).ifPresent(consumer);
            this.getPiece(tag, Type.SPY).ifPresent(consumer);
        } else {
            this.getPiece(tag, type).ifPresent(consumer);
        }
        return this;
    }

    @Nonnull
    public String getFormat(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            throw new IllegalArgumentException("Invalid type! " + (Object)((Object)type));
        }
        return this.getFormat(type.id);
    }

    public void setFormat(String format, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            this.setFormat(0, format);
            this.setFormat(1, format);
            this.setFormat(2, format);
        } else {
            this.setFormat(type.id, format);
        }
    }

    public String toString() {
        return "PrivateMessageEvent{sender=" + this.sender + ", target=" + this.target + ", senderChannel=" + this.senderChannel + ", targetChannel=" + this.targetChannel + ", spoofSend=" + this.spoofSend + '}';
    }

    public static enum Type {
        SENDER(0),
        TARGET(1),
        SPY(2),
        ALL(3);

        public final int id;

        private Type(int id) {
            this.id = id;
        }
    }
}

