/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api.events.internal;

import com.nickuc.chat.api.events.internal.MessageEvent;
import com.nickuc.chat.api.nChatAPI;
import com.nickuc.chat.api.util.Component;
import com.nickuc.chat.api.util.MessagePiece;
import com.nickuc.chat.api.util.map.MessagePieceMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class MultiFragmentableMessageEvent<T>
extends MessageEvent<T> {
    protected final MessagePieceMap[] pieces;
    private final String[] formats;
    private final String originalMessage;
    private String message;

    public MultiFragmentableMessageEvent(@Nonnull String message, int buf, String ... formats) {
        if (buf < 0) {
            throw new IllegalArgumentException("Negative buffer size! " + buf);
        }
        if (buf != formats.length) {
            throw new IllegalArgumentException("Buffer and formats sizes does not match! " + buf + " != " + formats.length);
        }
        this.pieces = MessagePieceMap.fill(buf);
        this.originalMessage = message;
        this.message = message;
        this.formats = new String[buf];
        for (int index = 0; index < buf; ++index) {
            String format = formats[index];
            if (format == null) {
                throw new IllegalArgumentException("Format cannot be null! index: " + index);
            }
            this.setFormat(index, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected MessagePieceMap getPieces(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        MessagePieceMap[] messagePieceMapArray = this.pieces;
        synchronized (this.pieces) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.pieces[index];
        }
    }

    @Nonnull
    public String getOriginalMessage() {
        return this.originalMessage;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected String getFormat(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        String[] stringArray = this.formats;
        synchronized (this.formats) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.formats[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMessage(@Nonnull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null!");
        }
        String trimmedMessage = message.trim();
        if (this.message.equals(trimmedMessage)) return;
        this.message = trimmedMessage;
        MessagePieceMap[] messagePieceMapArray = this.pieces;
        synchronized (this.pieces) {
            for (int i = 0; i < this.pieces.length; ++i) {
                this.getPiece(i, "message").ifPresent(piece -> piece.editText(trimmedMessage));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected List<String> getTags(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        MessagePieceMap[] messagePieceMapArray = this.pieces;
        synchronized (this.pieces) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new ArrayList<String>(this.pieces[index].keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<MessagePiece> getPiece(int index, String tag) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null!");
        }
        MessagePieceMap[] messagePieceMapArray = this.pieces;
        synchronized (this.pieces) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Optional.ofNullable((MessagePiece)this.pieces[index].get(tag.toLowerCase()));
        }
    }

    protected Optional<Component> getTag(int index, String tag) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null!");
        }
        return this.getPiece(index, tag).map(MessagePiece::component);
    }

    protected void setTag(int index, String tag, Component component) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null!");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null! Tag: {" + tag + "}");
        }
        this.getPiece(index, tag).ifPresent(piece -> piece.editComponent(component.clone()));
    }

    protected void setTag(int index, String tag, String content) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null!");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null! Tag: {" + tag + "}");
        }
        this.getPiece(index, tag).ifPresent(piece -> piece.editText(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setFormat(int index, String format) {
        if (index < 0) {
            throw new IllegalArgumentException("Negative index! " + index);
        }
        if (format == null) {
            throw new IllegalArgumentException("Format cannot be null!");
        }
        String[] stringArray = this.formats;
        synchronized (this.formats) {
            if (format.equals(this.formats[index])) return;
            this.formats[index] = format;
            MessagePieceMap[] messagePieceMapArray = this.pieces;
            synchronized (this.pieces) {
                nChatAPI.getApi().internal().processFormat(this.pieces, index, format);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }
}

