/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api.types;

import com.nickuc.chat.api.types.PlayerNameIdPair;
import com.nickuc.chat.channel.Channel;
import com.nickuc.chat.channel.PublicChannel;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface PlayerSession {
    public UUID id();

    public Optional<PublicChannel> getFocusedChannel();

    default public Collection<UUID> getIgnoredPlayers() {
        return this.getIgnored().stream().map(PlayerNameIdPair::getId).collect(Collectors.toSet());
    }

    public Collection<PlayerNameIdPair> getIgnored();

    default public Optional<UUID> getLastPrivateChatter() {
        return this.getLastPrivateChatterPlayer().map(PlayerNameIdPair::getId);
    }

    public Optional<PlayerNameIdPair> getLastPrivateChatterPlayer();

    default public Optional<UUID> getFocusedPrivateChatter() {
        return this.getFocusedPrivateChatterPlayer().map(PlayerNameIdPair::getId);
    }

    public Optional<PlayerNameIdPair> getFocusedPrivateChatterPlayer();

    public boolean isPrivateChannelEnabled();

    default public boolean isPrivateChannelDisabled() {
        return !this.isPrivateChannelEnabled();
    }

    public void setFocusedChannel(@Nullable PublicChannel var1);

    public void setIgnoredPlayers(@Nullable Collection<PlayerNameIdPair> var1);

    public void setLastPrivateChatter(@Nullable PlayerNameIdPair var1);

    public void setFocusedPrivateChatter(@Nullable PlayerNameIdPair var1);

    public void setPrivateChannelEnabled(boolean var1);

    public boolean isMentionable(UUID var1, Channel var2);
}

