/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.channel;

import com.nickuc.chat.channel.Channel;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PublicChannel
implements Channel {
    static final String[] EMPTY_STR_ARRAY = new String[0];
    private String name;
    private String permission;
    private String[] commands;
    private String format;
    private String spyFormat;
    private double distance;
    private double minBalance;
    private double messageCost;
    private double delayMessage;
    private boolean preventCapslock;
    private boolean showMessageCost;
    private boolean proxyChannel;
    private boolean mentionable;
    private boolean highlight;
    private boolean loggable;
    @Nullable
    private String[] proxyServers;

    public PublicChannel() {
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Channel name cannot be null!");
        }
        this.name = name;
    }

    @Nullable
    public String getCommand() {
        String[] commands = this.getCommands();
        return commands.length > 0 ? commands[0] : null;
    }

    public String[] getCommands() {
        if (this.commands == null) {
            throw new IllegalArgumentException("Channel commands cannot be null!");
        }
        return this.commands;
    }

    public void setCommands(Collection<String> commands) {
        this.commands = (String[])commands.stream().map(String::trim).map(s -> !s.isEmpty() && s.charAt(0) == '/' ? (s.length() > 1 ? s.substring(1) : "") : s).filter(s -> !s.isEmpty()).toArray(String[]::new);
    }

    public void setCommand(@Nullable String command) {
        if (command == null || (command = command.trim()).isEmpty()) {
            this.commands = new String[0];
            return;
        }
        String[] parts = command.split(",");
        String[] commands = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            commands[i] = parts[i].trim();
        }
        this.commands = commands;
    }

    @Nonnull
    public String getFormat() {
        if (this.format == null) {
            throw new IllegalArgumentException("Channel format cannot be null!");
        }
        return this.format;
    }

    @Nonnull
    public String[] getProxyServers() {
        return this.proxyServers == null ? EMPTY_STR_ARRAY : this.proxyServers;
    }

    public String getSpyFormat() {
        return this.spyFormat;
    }

    public String getPermission() {
        return this.permission;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getMinBalance() {
        return this.minBalance;
    }

    public double getMessageCost() {
        return this.messageCost;
    }

    public double getDelayMessage() {
        return this.delayMessage;
    }

    public boolean isShowMessageCost() {
        return this.showMessageCost;
    }

    public boolean isProxyChannel() {
        return this.proxyChannel;
    }

    public boolean isMentionable() {
        return this.mentionable;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public boolean isLoggable() {
        return this.loggable;
    }

    public boolean isPreventCapslock() {
        return this.preventCapslock;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setMinBalance(double minBalance) {
        this.minBalance = minBalance;
    }

    public void setMessageCost(double messageCost) {
        this.messageCost = messageCost;
    }

    public void setDelayMessage(double delayMessage) {
        this.delayMessage = delayMessage;
    }

    public void setShowMessageCost(boolean showMessageCost) {
        this.showMessageCost = showMessageCost;
    }

    public void setProxyChannel(boolean proxyChannel) {
        this.proxyChannel = proxyChannel;
    }

    public void setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public void setLoggable(boolean loggable) {
        this.loggable = loggable;
    }

    public void setPreventCapslock(boolean preventCapslock) {
        this.preventCapslock = preventCapslock;
    }

    public void setFormat(@Nonnull String format) {
        this.format = format;
    }

    public void setSpyFormat(String spyFormat) {
        this.spyFormat = spyFormat;
    }

    public void setProxyServers(@Nullable String[] proxyServers) {
        this.proxyServers = proxyServers;
    }

    private static String $default$format() {
        return "&cMissing format. Check your channel file.";
    }

    private static String $default$spyFormat() {
        return "";
    }

    private static boolean $default$preventCapslock() {
        return true;
    }

    public static PublicChannelBuilder builder() {
        return new PublicChannelBuilder();
    }

    private PublicChannel(String name, String permission, String[] commands, String format, String spyFormat, double distance, double minBalance, double messageCost, double delayMessage, boolean preventCapslock, boolean showMessageCost, boolean proxyChannel, boolean mentionable, boolean highlight, boolean loggable, @Nullable String[] proxyServers) {
        this.name = name;
        this.permission = permission;
        this.commands = commands;
        this.format = format;
        this.spyFormat = spyFormat;
        this.distance = distance;
        this.minBalance = minBalance;
        this.messageCost = messageCost;
        this.delayMessage = delayMessage;
        this.preventCapslock = preventCapslock;
        this.showMessageCost = showMessageCost;
        this.proxyChannel = proxyChannel;
        this.mentionable = mentionable;
        this.highlight = highlight;
        this.loggable = loggable;
        this.proxyServers = proxyServers;
    }

    public String toString() {
        return "PublicChannel(name=" + this.getName() + ", permission=" + this.getPermission() + ", commands=" + Arrays.deepToString(this.getCommands()) + ", format=" + this.getFormat() + ", spyFormat=" + this.getSpyFormat() + ", distance=" + this.getDistance() + ", minBalance=" + this.getMinBalance() + ", messageCost=" + this.getMessageCost() + ", delayMessage=" + this.getDelayMessage() + ", preventCapslock=" + this.isPreventCapslock() + ", showMessageCost=" + this.isShowMessageCost() + ", proxyChannel=" + this.isProxyChannel() + ", mentionable=" + this.isMentionable() + ", highlight=" + this.isHighlight() + ", loggable=" + this.isLoggable() + ", proxyServers=" + Arrays.deepToString(this.getProxyServers()) + ")";
    }

    public static class PublicChannelBuilder {
        private String name;
        private String permission;
        private String[] commands;
        private boolean format$set;
        private String format$value;
        private boolean spyFormat$set;
        private String spyFormat$value;
        private double distance;
        private double minBalance;
        private double messageCost;
        private double delayMessage;
        private boolean preventCapslock$set;
        private boolean preventCapslock$value;
        private boolean showMessageCost;
        private boolean proxyChannel;
        private boolean mentionable;
        private boolean highlight;
        private boolean loggable;
        private String[] proxyServers;

        PublicChannelBuilder() {
        }

        public PublicChannelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PublicChannelBuilder permission(String permission) {
            this.permission = permission;
            return this;
        }

        public PublicChannelBuilder commands(String[] commands) {
            this.commands = commands;
            return this;
        }

        public PublicChannelBuilder format(String format) {
            this.format$value = format;
            this.format$set = true;
            return this;
        }

        public PublicChannelBuilder spyFormat(String spyFormat) {
            this.spyFormat$value = spyFormat;
            this.spyFormat$set = true;
            return this;
        }

        public PublicChannelBuilder distance(double distance) {
            this.distance = distance;
            return this;
        }

        public PublicChannelBuilder minBalance(double minBalance) {
            this.minBalance = minBalance;
            return this;
        }

        public PublicChannelBuilder messageCost(double messageCost) {
            this.messageCost = messageCost;
            return this;
        }

        public PublicChannelBuilder delayMessage(double delayMessage) {
            this.delayMessage = delayMessage;
            return this;
        }

        public PublicChannelBuilder preventCapslock(boolean preventCapslock) {
            this.preventCapslock$value = preventCapslock;
            this.preventCapslock$set = true;
            return this;
        }

        public PublicChannelBuilder showMessageCost(boolean showMessageCost) {
            this.showMessageCost = showMessageCost;
            return this;
        }

        public PublicChannelBuilder proxyChannel(boolean proxyChannel) {
            this.proxyChannel = proxyChannel;
            return this;
        }

        public PublicChannelBuilder mentionable(boolean mentionable) {
            this.mentionable = mentionable;
            return this;
        }

        public PublicChannelBuilder highlight(boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public PublicChannelBuilder loggable(boolean loggable) {
            this.loggable = loggable;
            return this;
        }

        public PublicChannelBuilder proxyServers(@Nullable String[] proxyServers) {
            this.proxyServers = proxyServers;
            return this;
        }

        public PublicChannel build() {
            String format$value = this.format$value;
            if (!this.format$set) {
                format$value = PublicChannel.$default$format();
            }
            String spyFormat$value = this.spyFormat$value;
            if (!this.spyFormat$set) {
                spyFormat$value = PublicChannel.$default$spyFormat();
            }
            boolean preventCapslock$value = this.preventCapslock$value;
            if (!this.preventCapslock$set) {
                preventCapslock$value = PublicChannel.$default$preventCapslock();
            }
            return new PublicChannel(this.name, this.permission, this.commands, format$value, spyFormat$value, this.distance, this.minBalance, this.messageCost, this.delayMessage, preventCapslock$value, this.showMessageCost, this.proxyChannel, this.mentionable, this.highlight, this.loggable, this.proxyServers);
        }

        public String toString() {
            return "PublicChannel.PublicChannelBuilder(name=" + this.name + ", permission=" + this.permission + ", commands=" + Arrays.deepToString(this.commands) + ", format$value=" + this.format$value + ", spyFormat$value=" + this.spyFormat$value + ", distance=" + this.distance + ", minBalance=" + this.minBalance + ", messageCost=" + this.messageCost + ", delayMessage=" + this.delayMessage + ", preventCapslock$value=" + this.preventCapslock$value + ", showMessageCost=" + this.showMessageCost + ", proxyChannel=" + this.proxyChannel + ", mentionable=" + this.mentionable + ", highlight=" + this.highlight + ", loggable=" + this.loggable + ", proxyServers=" + Arrays.deepToString(this.proxyServers) + ")";
        }
    }
}

