/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.api.events;

import br.com.devpaulo.legendchat.channels.types.Channel;
import com.nickuc.chat.api.lc.internal.event.LCCancellableEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;

public class ChatMessageEvent
extends LCCancellableEvent {
    private final Channel channel;
    private final Player sender;
    private String message;
    private String format;
    private final Set<Player> recipients;
    private final Map<String, String> tags;

    public ChatMessageEvent(Channel channel, Player sender, String message, String format, Set<Player> recipients, Map<String, String> tags) {
        super(true);
        this.channel = channel;
        this.sender = sender;
        this.message = message;
        this.format = format;
        this.recipients = recipients;
        this.tags = tags;
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public void setFormat(String format) {
        Validate.notNull((Object)format, (String)"Format cannot be null");
        this.format = format.replace("\n", "\\n").replace("\r", "\\r");
    }

    @Deprecated
    public void setSender(Player sender) {
        if (sender == null) {
            this.cancelled = true;
        }
    }

    @Deprecated
    public String getBukkitFormat() {
        return this.format;
    }

    @Deprecated
    public String getBaseFormat() {
        return this.format;
    }

    @Deprecated
    public String baseFormatToFormat(String baseFormat) {
        return baseFormat;
    }

    public List<String> getTags() {
        return new ArrayList<String>(this.tags.keySet());
    }

    public boolean setTagValue(String tag, String value) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null for tag \"" + tag + "\"");
        }
        boolean exists = this.tags.containsKey(tag = tag.toLowerCase());
        if (exists) {
            this.tags.put(tag, value);
        }
        return exists;
    }

    @Nullable
    public String getTagValue(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        return this.tags.getOrDefault(tag.toLowerCase(), null);
    }

    @Deprecated
    public void addTag(String tag, String value) {
        this.setTagValue(tag, value);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Player getSender() {
        return this.sender;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormat() {
        return this.format;
    }

    public Set<Player> getRecipients() {
        return this.recipients;
    }
}

