/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api.events;

import com.nickuc.chat.api.events.internal.MultiFragmentableMessageEvent;
import com.nickuc.chat.api.events.internal.SpoofableEvent;
import com.nickuc.chat.api.nChatAPI;
import com.nickuc.chat.api.util.Component;
import com.nickuc.chat.api.util.MessagePiece;
import com.nickuc.chat.api.util.map.MessagePieceMap;
import com.nickuc.chat.channel.PrivateChannel;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.TextComponent;

public class ProxyPrivateMessageEvent
extends MultiFragmentableMessageEvent<ProxyPrivateMessageEvent>
implements SpoofableEvent {
    public static final int STAGE_SENDER_PREPARING_MESSAGE = 0;
    public static final int STAGE_SENDER_TO_TARGET = 1;
    public static final int STAGE_TARGET_PREPARING_MESSAGE = 2;
    public static final int STAGE_TARGET_TO_SENDER = 3;
    public static final int ERR_PLAYER_IS_OFFLINE = 0;
    public static final int ERR_TELL_DISABLED = 1;
    public static final int ERR_TELL_IGNORED = 2;
    public static final int ERR_NOT_AUTHENTICATED = 3;
    @Nonnull
    private final UUID senderId;
    @Nonnull
    private final UUID targetId;
    @Nonnull
    private final String senderName;
    @Nonnull
    private final String targetName;
    @Nonnull
    private final PrivateChannel privateChannel;
    private final String serverName;
    private final int stage;
    private boolean spoofSend;

    public ProxyPrivateMessageEvent(@Nonnull PrivateChannel privateChannel, @Nonnull UUID senderId, @Nonnull UUID targetId, @Nonnull String senderName, @Nonnull String targetName, @Nonnull String message, String serverName, int stage, String ... formats) {
        super(message, 3, formats);
        this.senderName = senderName;
        this.targetName = targetName;
        this.senderId = senderId;
        this.targetId = targetId;
        this.privateChannel = privateChannel;
        this.serverName = serverName;
        this.stage = stage;
    }

    public static String[] getProxyTellFormats(PrivateChannel channel, int stage) {
        switch (stage) {
            case 0: {
                return new String[]{"", channel.getTargetFormat(), channel.getSpyFormat()};
            }
            case 2: {
                return new String[]{channel.getSenderFormat(), "", channel.getSpyFormat()};
            }
        }
        throw new UnsupportedOperationException("Unsupported stage! " + stage);
    }

    public static String[] getBungeeTellFormats(PrivateChannel channel, int stage) {
        return ProxyPrivateMessageEvent.getProxyTellFormats(channel, stage);
    }

    @Nonnull
    public String getSender() {
        return this.senderName;
    }

    @Nonnull
    public String getTarget() {
        return this.targetName;
    }

    @Nonnull
    public UUID getSenderId() {
        return this.senderId;
    }

    @Nonnull
    public UUID getTargetId() {
        return this.targetId;
    }

    @Override
    public boolean isSpoofSend() {
        return this.spoofSend;
    }

    @Override
    public void setSpoofSend() {
        if (!this.spoofSend) {
            this.recipients.removeIf(player -> !player.getName().equals(this.senderName));
        }
        this.spoofSend = true;
    }

    @Nonnull
    public PrivateChannel getChannel() {
        return this.privateChannel;
    }

    public int getStage() {
        return this.stage;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    @Nonnull
    public String getSenderFormat() throws IllegalStateException {
        this.checkSenderStage();
        return this.getFormat(0);
    }

    @Nonnull
    public String getTargetFormat() throws IllegalStateException {
        this.checkTargetStage();
        return this.getFormat(1);
    }

    @Nonnull
    public String getSpyFormat() {
        return this.getFormat(2);
    }

    public Optional<MessagePiece> getPiece(String tag, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            throw new IllegalArgumentException("Invalid type! " + (Object)((Object)type));
        }
        type.checkStage(this);
        return super.getPiece(type.id, tag);
    }

    @Nonnull
    public MessagePieceMap getPieces(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            throw new IllegalArgumentException("Invalid type! " + (Object)((Object)type));
        }
        type.checkStage(this);
        return super.getPieces(type.id);
    }

    public Optional<Component> getTagComponent(String tag, Type type) {
        return this.getPiece(tag, type).map(MessagePiece::component);
    }

    public Optional<TextComponent> getTag(String tag, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        type.checkStage(this);
        return super.getTag(type.id, tag).map(component -> Component.to(component, TextComponent.class));
    }

    @Nonnull
    public TextComponent getTagValue(String tag, Type type) {
        Component component = this.getTagComponent(tag, type).orElse(nChatAPI.getApi().internal().emptyReadOnlyComponent());
        return Component.to(component, TextComponent.class);
    }

    public void setTag(String tag, Component component, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null! Tag: {" + tag + "}");
        }
        Consumer<MessagePiece> consumer = piece -> piece.editComponent(component.clone());
        if (type == Type.ALL) {
            Type t = this.stage == 0 || this.stage == 1 ? Type.TARGET : Type.SENDER;
            this.getPiece(tag, t).ifPresent(consumer);
            this.getPiece(tag, Type.SPY).ifPresent(consumer);
        } else {
            this.getPiece(tag, type).ifPresent(consumer);
        }
    }

    public void setTag(String tag, TextComponent component, Type type) {
        this.setTag(tag, Component.from(component), type);
    }

    public void setTag(String tag, String content, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null! Tag: {" + tag + "}");
        }
        Consumer<MessagePiece> consumer = piece -> piece.editText(content);
        if (type == Type.ALL) {
            Type t = this.stage == 0 || this.stage == 1 ? Type.TARGET : Type.SENDER;
            this.getPiece(tag, t).ifPresent(consumer);
            this.getPiece(tag, Type.SPY).ifPresent(consumer);
        } else {
            this.getPiece(tag, type).ifPresent(consumer);
        }
    }

    @Nonnull
    public String getFormat(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        if (type == Type.ALL) {
            throw new IllegalArgumentException("Invalid type! " + (Object)((Object)type));
        }
        type.checkStage(this);
        return this.getFormat(type.id);
    }

    public void setFormat(String format, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        type.checkStage(this);
        if (type == Type.ALL) {
            Type t = this.stage == 0 || this.stage == 1 ? Type.TARGET : Type.SENDER;
            this.setFormat(t.id, format);
            this.setFormat(Type.SPY.id, format);
        } else {
            this.setFormat(type.id, format);
        }
    }

    private void checkSenderStage() {
        ProxyPrivateMessageEvent.checkMethodState(this.stage != 2 && this.stage != 3, "STAGE_TARGET_PREPARING_MESSAGE or STAGE_TARGET_TO_SENDER");
    }

    private void checkTargetStage() {
        ProxyPrivateMessageEvent.checkMethodState(this.stage != 0 && this.stage != 1, "STAGE_SENDER_PREPARING_MESSAGE or STAGE_SENDER_TO_TARGET");
    }

    private static void checkMethodState(boolean bool, String stage) {
        if (bool) {
            throw new IllegalStateException(String.format("You can only access this method in the %s stage.", stage));
        }
    }

    public String toString() {
        return "ProxyPrivateMessageEvent{senderId=" + this.senderId + ", targetId=" + this.targetId + ", senderName='" + this.senderName + '\'' + ", targetName='" + this.targetName + '\'' + ", privateChannel=" + this.privateChannel + ", serverName='" + this.serverName + '\'' + ", stage=" + this.stage + ", spoofSend=" + this.spoofSend + '}';
    }

    public static enum Type {
        SENDER(0),
        TARGET(1),
        SPY(2),
        ALL(3);

        public final int id;

        void checkStage(ProxyPrivateMessageEvent event) {
            switch (this) {
                case SENDER: {
                    event.checkSenderStage();
                    break;
                }
                case TARGET: {
                    event.checkTargetStage();
                }
            }
        }

        private Type(int id) {
            this.id = id;
        }
    }
}

