/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api.events;

import com.nickuc.chat.api.events.internal.FragmentableMessageEvent;
import com.nickuc.chat.api.events.internal.SpoofableEvent;
import com.nickuc.chat.channel.PublicChannel;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ProxyPublicMessageEvent
extends FragmentableMessageEvent<ProxyPublicMessageEvent>
implements SpoofableEvent {
    @Nonnull
    private final UUID senderId;
    @Nonnull
    private final String senderName;
    @Nonnull
    private final String serverName;
    private boolean highlight;
    private boolean spoofSend;

    public ProxyPublicMessageEvent(PublicChannel publicChannel, @Nonnull UUID senderId, @Nonnull String senderName, @Nonnull String message, @Nonnull String serverName, boolean highlight) {
        super(publicChannel, message);
        this.senderId = senderId;
        this.senderName = senderName;
        this.serverName = serverName;
        this.highlight = highlight;
    }

    @Nonnull
    public String getSender() {
        return this.senderName;
    }

    @Nonnull
    public UUID getSenderId() {
        return this.senderId;
    }

    @Nonnull
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public boolean isSpoofSend() {
        return this.spoofSend;
    }

    @Override
    public void setSpoofSend() {
        if (!this.spoofSend) {
            this.recipients.removeIf(player -> !player.getName().equals(this.senderName));
        }
        this.spoofSend = true;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public String toString() {
        return "ProxyPublicMessageEvent{senderId=" + this.senderId + ", senderName='" + this.senderName + '\'' + ", serverName='" + this.serverName + '\'' + ", highlight=" + this.highlight + ", spoofSend=" + this.spoofSend + ", publicChannel=" + this.publicChannel + '}';
    }
}

