/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api.events.internal;

import com.nickuc.chat.api.events.internal.MultiFragmentableMessageEvent;
import com.nickuc.chat.api.nChatAPI;
import com.nickuc.chat.api.util.Component;
import com.nickuc.chat.api.util.MessagePiece;
import com.nickuc.chat.api.util.map.MessagePieceMap;
import com.nickuc.chat.channel.PublicChannel;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class FragmentableMessageEvent<T>
extends MultiFragmentableMessageEvent<T> {
    protected final PublicChannel publicChannel;

    public FragmentableMessageEvent(@Nonnull PublicChannel publicChannel, @Nonnull String message) {
        super(message, 2, publicChannel.getFormat(), publicChannel.getSpyFormat());
        this.publicChannel = publicChannel;
    }

    @Nonnull
    public MessagePieceMap getSenderPieces() {
        return super.getPieces(0);
    }

    @Nonnull
    public MessagePieceMap getSpyPieces() {
        return super.getPieces(1);
    }

    @Nonnull
    public PublicChannel getChannel() {
        return this.publicChannel;
    }

    @Nonnull
    public String getFormat() {
        return this.getFormat(0);
    }

    @Nonnull
    public String getSpyFormat() {
        return this.getFormat(1);
    }

    @Nonnull
    public List<String> getTags() {
        return this.getTags(0);
    }

    @Nonnull
    public List<String> getSpyTags() {
        return this.getTags(1);
    }

    public Optional<MessagePiece> getSenderPiece(String tag) {
        return super.getPiece(0, tag);
    }

    public Optional<MessagePiece> getSpyPiece(String tag) {
        return super.getPiece(1, tag);
    }

    @Nonnull
    public Optional<Component> getTagComponent(String tag) {
        return super.getTag(0, tag);
    }

    @Nonnull
    public Optional<Component> getSpyTagComponent(String tag) {
        return super.getTag(1, tag);
    }

    public Optional<TextComponent> getTag(String tag) {
        return super.getTag(0, tag).map(component -> Component.to(component, TextComponent.class));
    }

    public Optional<TextComponent> getSpyTag(String tag) {
        return super.getTag(1, tag).map(component -> Component.to(component, TextComponent.class));
    }

    @Nonnull
    public TextComponent getTagValue(String tag) {
        Component component = super.getTag(0, tag).orElse(nChatAPI.getApi().internal().emptyReadOnlyComponent());
        return Component.to(component, TextComponent.class);
    }

    @Nonnull
    public TextComponent getSpyTagValue(String tag) {
        Component component = super.getTag(1, tag).orElse(nChatAPI.getApi().internal().emptyReadOnlyComponent());
        return Component.to(component, TextComponent.class);
    }

    public void setTag(String tag, Component component) {
        super.setTag(0, tag, component);
        super.setTag(1, tag, component);
    }

    public T setTag(String tag, TextComponent textComponent) {
        Component component = Component.from(textComponent);
        super.setTag(0, tag, component);
        super.setTag(1, tag, component);
        return (T)((Object)this);
    }

    public T setTag(String tag, String content) {
        super.setTag(0, tag, content);
        super.setTag(1, tag, content);
        return (T)((Object)this);
    }

    public void setSpyTag(String tag, Component component) {
        super.setTag(1, tag, component);
    }

    public T setSpyTag(@Nonnull String tag, @Nonnull TextComponent component) {
        super.setTag(1, tag, Component.from(new TextComponent(component)));
        return (T)((Object)this);
    }

    public void setSpyTag(@Nonnull String tag, @Nonnull String content) {
        super.setTag(1, tag, content);
    }

    public void setFormat(@Nonnull String format) {
        super.setFormat(0, format);
    }

    public void setSpyFormat(@Nonnull String spyFormat) {
        super.setFormat(1, spyFormat);
    }
}

