/*
 * Decompiled with CFR 0.152.
 */
package com.nickuc.chat.api;

import com.nickuc.chat.api.events.PublicMessageEvent;
import com.nickuc.chat.api.events.VirtualMessageEvent;
import com.nickuc.chat.api.nChatAPIHolder;
import com.nickuc.chat.api.translator.GlobalTag;
import com.nickuc.chat.api.types.PlayerSession;
import com.nickuc.chat.api.util.Component;
import com.nickuc.chat.api.util.map.MessagePieceMap;
import com.nickuc.chat.channel.Channel;
import com.nickuc.chat.channel.PrivateChannel;
import com.nickuc.chat.channel.PublicChannel;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public interface nChatAPI {
    @Nonnull
    public static nChatAPI getApi() {
        return nChatAPIHolder.getApi();
    }

    @Deprecated
    default public boolean isLoaded() {
        return true;
    }

    @Nonnull
    public String getVersion();

    public int getApiVersion();

    public PlayerSession getSession(@Nonnull Player var1);

    @Nullable
    public GlobalTag getGlobalTag(@Nonnull String var1);

    default public boolean removeGlobalTag(@Nonnull String tag) {
        return this.setGlobalTag(tag, null);
    }

    default public boolean setGlobalTag(@Nonnull String tag, @Nullable GlobalTag globalTag) {
        return this.setGlobalTag(tag, globalTag, true);
    }

    public boolean setGlobalTag(@Nonnull String var1, @Nullable GlobalTag var2, boolean var3);

    @Nonnull
    public String replacePlaceholders(@Nonnull Player var1, @Nonnull String var2);

    @Nonnull
    public Set<PublicChannel> getPublicChannels();

    @Nonnull
    public Set<PrivateChannel> getPrivateChannels();

    public Optional<PublicChannel> getChannelByName(@Nonnull String var1);

    public Optional<PrivateChannel> getPrivateChannelByName(@Nonnull String var1, boolean var2);

    public Optional<PublicChannel> getChannelByCommand(@Nonnull String var1);

    public Optional<PublicChannel> getChannelByNameAndCommand(@Nonnull String var1);

    default public boolean hasChannelByName(@Nonnull String name) {
        return this.getChannelByName(name).isPresent();
    }

    default public boolean hasPrivateChannelByName(@Nonnull String name, boolean isProxy) {
        return this.getPrivateChannelByName(name, isProxy).isPresent();
    }

    default public boolean hasChannelByCommand(@Nonnull String command) {
        return this.getChannelByCommand(command).isPresent();
    }

    default public boolean hasChannelByNameAndCommand(@Nonnull String input) {
        return this.getChannelByNameAndCommand(input).isPresent();
    }

    default public void handlePublicMessage(@Nonnull Player sender, @Nonnull String message, @Nonnull PublicChannel publicChannel, @Nullable Consumer<PublicMessageEvent> callback) {
        this.handlePublicMessage(sender, message, publicChannel, false, callback);
    }

    public void handlePublicMessage(@Nonnull Player var1, @Nonnull String var2, @Nonnull PublicChannel var3, boolean var4, @Nullable Consumer<PublicMessageEvent> var5);

    default public void handleVirtualMessage(@Nonnull String format, @Nonnull PublicChannel publicChannel, @Nullable Consumer<VirtualMessageEvent> callback) {
        this.handleVirtualMessage(format, publicChannel, false, callback);
    }

    default public void handleVirtualMessage(@Nonnull String format, @Nonnull PublicChannel publicChannel, boolean highlight, @Nullable Consumer<VirtualMessageEvent> callback) {
        this.handleVirtualMessage(null, format, publicChannel, highlight, callback);
    }

    default public void handleVirtualMessage(@Nullable String sender, @Nonnull String format, @Nonnull PublicChannel publicChannel, @Nullable Consumer<VirtualMessageEvent> callback) {
        this.handleVirtualMessage(sender, format, publicChannel, false, callback);
    }

    public void handleVirtualMessage(@Nullable String var1, @Nonnull String var2, @Nonnull PublicChannel var3, boolean var4, @Nullable Consumer<VirtualMessageEvent> var5);

    public void reloadConfig();

    public void reloadChannels();

    public boolean createChannel(@Nonnull Channel var1);

    public boolean reloadChannel(@Nonnull Channel var1);

    public boolean saveChannel(@Nonnull Channel var1);

    public boolean deleteChannel(@Nonnull Channel var1);

    public nChatInternal internal();

    public static interface nChatInternal {
        public void processFormat(MessagePieceMap[] var1, int var2, String var3);

        public Component emptyReadOnlyComponent();

        public Component createComponent(Object var1);

        public <T> T convertComponent(Component var1, Class<T> var2);

        public void copyChannel(File var1);
    }
}

